SELECT PATIENT, 
		SSN, 
		EVENT_TIME, 
		REQUEST_DT, 
		CURRENT_WARD, 
		TYPE_OF_BED_REQUESTED, 
		RECORD_LAST_EDITED_BY, 
		RECORD_LAST_EDIT_DATE, 
		CURRENT_WAIT_AREA, 
		ACUTE,
		AUTHORIZED_FEE, 
		BED_ASSIGNED_DT, 
		COMMUNITY_SERVICES, 
		CONTRACTED, 
		FEE_COMMENTS, 
		REASON_USING_FEE, 
		ROOM_BED_ASSIGNED,
		NULL AS REMOVED_DATE,
		'INSERT' AS OPERATION
FROM dbo.Bed_Control_Waiting WHERE REMOVE_FROM_LIST IS NULL AND EVENT_TIME>='@START_DATE'
UNION 
SELECT PATIENT, 
		SSN, 
		EVENT_TIME, 
		REQUEST_DT, 
		CURRENT_WARD, 
		TYPE_OF_BED_REQUESTED, 
		RECORD_LAST_EDITED_BY, 
		RECORD_LAST_EDIT_DATE, 
		CURRENT_WAIT_AREA, 
		ACUTE,
		AUTHORIZED_FEE, 
		BED_ASSIGNED_DT, 
		COMMUNITY_SERVICES, 
		CONTRACTED, 
		FEE_COMMENTS, 
		REASON_USING_FEE, 
		ROOM_BED_ASSIGNED,
		CAST(REMOVE_FROM_LIST AS DATETIME) AS REMOVED_DATE,
		'REMOVE' AS OPERATION
FROM dbo.Bed_Control_Waiting WHERE REMOVE_FROM_LIST IS NOT NULL AND EVENT_TIME<'@START_DATE' AND CAST(REMOVE_FROM_LIST AS DATETIME) >='@START_DATE'
UNION 
SELECT PATIENT, 
		SSN, 
		EVENT_TIME, 
		REQUEST_DT, 
		CURRENT_WARD, 
		TYPE_OF_BED_REQUESTED, 
		RECORD_LAST_EDITED_BY, 
		RECORD_LAST_EDIT_DATE, 
		CURRENT_WAIT_AREA, 
		ACUTE,
		AUTHORIZED_FEE, 
		BED_ASSIGNED_DT, 
		COMMUNITY_SERVICES, 
		CONTRACTED, 
		FEE_COMMENTS, 
		REASON_USING_FEE, 
		ROOM_BED_ASSIGNED,
		NULL AS REMOVED_DATE,
		'UPDATE' AS OPERATION
FROM dbo.Bed_Control_Waiting WHERE REMOVE_FROM_LIST IS NULL AND EVENT_TIME<'@START_DATE' AND RECORD_LAST_EDIT_DATE >='@START_DATE'